jQuery(document).ready(function(){
  
  //jquery objects
  var g_objMenu = jQuery('#{{uc_id}}');  
  var g_objFirstLevelMenuItems = g_objMenu.find('.ue-menu > .menu-item-has-children');
  var g_objMenuItems = g_objMenu.find('.menu-item-has-children');
  var g_objMenuInnerItems = g_objMenu.find('.menu-item-has-children .menu-item-has-children');
  var g_objMenuLinks = g_objMenu.find('a');
  var objExpandIcon = g_objMenu.find('.ue-nav-menu-icon-expand');
  var g_objBurger = g_objMenu.find('.ue-nav-menu-mobile');
  var g_objOpenBurgerIcon = g_objMenu.find('.ue-nav-menu-mobile-icon-open');
  var g_objCloseBurgerIcon = g_objMenu.find('.ue-nav-menu-mobile-icon-close');
  
  //classes
  var g_classActive = 'uc-active';
  var hasChildrenClass = 'menu-item-has-children';
  
  //selectors
  var menuItemSelector = '.'+hasChildrenClass;
  var iconsSelector = '.ue-nav-menu-icon';
  var subMenuSelector = '.sub-menu';
  var linkSelector = '> a';
  
  //data attributes
  var g_showIcons = g_objMenu.data('show-icons');
  var dataCustomBreakpoint = g_objMenu.data('breakpoint');
  
  //html elements
  var g_expandIconHtml = objExpandIcon.html();  	
  
  //window width
  var g_viewportWidth = jQuery(window).width();
  var g_isResponsiveViewport = window.matchMedia("(max-width: "+dataCustomBreakpoint+"px)");
  
  function isClickedItemOnFirstLevel(objIcon){
    
    var firstLevelIconClass = 'uc-first-level-item';
    
    //check if clicked itcon is not first level icon
    var objFirstLevelIcons = g_objFirstLevelMenuItems.find(linkSelector).find(iconsSelector);
    
    objFirstLevelIcons.addClass(firstLevelIconClass);
    
    if(objIcon.hasClass(firstLevelIconClass) == true)
    return(true);
    else
    return(false);
    
  }
  
  function setActiveIcon(objClicked){
    
    if(g_showIcons == false)
    return(false);
    
    if(objClicked.hasClass(g_classActive) == false)
    return(false);
    
    var objIcon = objClicked.find(iconsSelector);
    
    var collapseIconHtml = g_objMenu.find('.ue-nav-menu-icon-collapse').html();
    
    if(isClickedItemOnFirstLevel(objIcon) == true)
    return(false);  
    
    objIcon.html(collapseIconHtml);
    
  }
  
  function setDisactiveIcon(objClicked){
    
    if(g_showIcons == false)
    return(false);
    
    var objIcon = objClicked.find(iconsSelector);
    
    if(isClickedItemOnFirstLevel(objIcon) == true)
    return(false);  
    
    objIcon.html(g_expandIconHtml);
    
  }
  
  function cancelFullWidth(objMobileMenu){
    
    objMobileMenu.css({
      'width': '',
      'left': ''
    });
    
  }
  
  function setMenuToFullWidth(objMobileMenu){
    
    var dataFullWidth = g_objMenu.data('full-width');
    
    if(dataFullWidth == false)
    return(false);
    
    //if not mobile viewport - cancel full width and exit function
    if(g_isResponsiveViewport.matches == false){        
      cancelFullWidth(objMobileMenu);
      return(false);          
    }      	
    
    //set width to full
    objMobileMenu.css('width', g_viewportWidth+'px');
    
    //set left position
    var menuLeftPosition = g_objMenu.offset().left;
    
    objMobileMenu.css('left', -menuLeftPosition+'px');
    
    
  }
  
  function initResponsiveMode(){
    
    var objSubMenus = g_objMenu.find(subMenuSelector);
    var objMobileMenu = g_objMenu.find('.ue-menu');
    var mobileClass = 'uc-mobile';
    
    //update viewport width value
    g_viewportWidth = jQuery(window).width();      
    
    //set full width if needed
    setTimeout(function(){
      setMenuToFullWidth(objMobileMenu);
    },200);
    
    if(g_isResponsiveViewport.matches == false){
      
      //remove mobile class from menu
      objMobileMenu.removeClass(mobileClass);
      
      objSubMenus.slideDown(300);    
      
      var objLinks = objSubMenus.prev();
      
      correctOpenMenuPosition(objLinks);
      
    }        
    
    if(g_isResponsiveViewport.matches == true){
      
      //add mobile class to menu
      objMobileMenu.addClass(mobileClass);
      
      objSubMenus.slideUp(300);
      
      if(g_objBurger.hasClass(g_classActive) == true){
        
        g_objOpenBurgerIcon.removeClass(g_classActive);
        g_objCloseBurgerIcon.addClass(g_classActive);
        
      }else{
        
        g_objOpenBurgerIcon.addClass(g_classActive);
        g_objCloseBurgerIcon.removeClass(g_classActive);
        
      }
      
    }      	
    
  }
  
  /*
  *	correct menu item position when there is no space inside viewport
  */
  function correctOpenMenuPosition(objTarget){  
    
    //only on desktop
    if(g_isResponsiveViewport.matches == true)
    return(false);
    
    var objSubMenu = objTarget.next();
    
    // if no sub menus return 
    if(!objSubMenu.length)
    return(false);
    
    var objParentSubMenus = objTarget.parents(subMenuSelector);
    
    //search only from second level menu items
    if(!objParentSubMenus.length)
    return(false);  
    
    //each parent submenu
    objParentSubMenus.each(function(parentIndex, parent){
      
      var objParentSubMenu = jQuery(this);
      
      // Get the position of the menu item relative to the viewport
      var objChildSubMenus = objParentSubMenu.find('li >'+subMenuSelector);
      
      if(!objChildSubMenus.length)
      return(true);
      
      //each child submenu
      objChildSubMenus.each(function(childIndex, child){
        
        var objChildSubMenu = jQuery(this);        
        
        //width of the child
        var menuItemChildWidth = objChildSubMenu.width();
        
        //width of the parent
        var menuItemParentWidth = objParentSubMenu.width();
        
        //right offset of the parent
        var menuItemRightOffset = objParentSubMenu.offset().left + menuItemParentWidth;
        var menuItemLeftOffset = objParentSubMenu.offset().left;
        
        // Get the available space on both sides of the screen
        var spaceRight = window.innerWidth - menuItemRightOffset;
        
        //get inset-inline-start value
        var insetInlineStart = objChildSubMenu.css('inset-inline-start');        
        
        // if there is NOT enough room (left or right) then invert insert-inline-start 
        if (menuItemChildWidth >= spaceRight || menuItemChildWidth >= menuItemLeftOffset)
        objChildSubMenu.css('inset-inline-start', '-'+insetInlineStart);
        
        // if there is NOT enough room anywhere
        if (menuItemChildWidth >= spaceRight && menuItemChildWidth >= menuItemLeftOffset){
          
          console.log('Can"t correct position of the dropdown, please adjust width of menu items');
          
          return(true);
          
        }      
        
        //if there is enough room then cancel invert insert-inline-start
        if (menuItemChildWidth < spaceRight && childIndex != parentIndex){
          
          //menuItemChildWidth x2 times because its equal to inset-inline-start
          var childSubMenuOffsetRight = objParentSubMenu.offset().left + menuItemParentWidth + menuItemChildWidth + menuItemChildWidth; 
      
          //cancel when child sub-menu offset right is not grater then viewport width (must check if after canceling won't be any horizontal scroll)     
          if(childSubMenuOffsetRight < window.innerWidth)
          objChildSubMenu.css('inset-inline-start', '');

        }        
        
      });
      
    });
    
    
  }
  
  /*
  * responsive mode menu item click
  */  
  function onMenuLinkClick(e){
    
    if(g_isResponsiveViewport.matches == false)
    return(true);
    
    var objLink = jQuery(this);
    var objSubMenu = objLink.next();
    
    //if click on active item then close it
    if(objLink.hasClass(g_classActive) == true){
      
      setDisactiveIcon(objLink);
      
      objSubMenu.slideUp(300);
      
      objLink.removeClass(g_classActive);
      
      return(true);
      
    }   
    
    var objSubMenusParent = objSubMenu.parents(subMenuSelector);      	
    var objSubMenusNotParents = g_objMenu.find(subMenuSelector).not(objSubMenusParent);    
    var objMenuLinksParent = objLink.parents(subMenuSelector).prev();
    var objMenuLinksNotParents = g_objMenu.find('a').not(objMenuLinksParent);
    
    objMenuLinksNotParents.removeClass(g_classActive);
    objLink.addClass(g_classActive);
    
    setDisactiveIcon(objMenuLinksNotParents);
    setActiveIcon(objLink);        
    
    objSubMenusNotParents.slideUp(300);
    objSubMenu.slideDown(300);  
    
    if(objSubMenu.length > 0)
    e.preventDefault();    
    
  }
  
  function onMenuInnerItemMouseover(e){
    
    if(g_isResponsiveViewport.matches == true)
    return(false);
    
    var objHovered = jQuery(this);    
    var objItem = objHovered.find(linkSelector);
    
    setTimeout(function(){
      setActiveIcon(objItem);
    },100);  
    
    var objTarget = jQuery(e.target);
    correctOpenMenuPosition(objTarget);
    
  }
  
  function onMenuInnerItemMouseLeave(){
    
    if(g_isResponsiveViewport.matches == true)
    return(false);
    
    var objMenuItem = jQuery(this);    
    var objItem = objMenuItem.find(linkSelector);
    
    setDisactiveIcon(objItem);       
    
  }
  
  /**
  * use this funciton to add active class to all menu item links
  */
  function onMenuItemMouseover(){
    
    if(g_isResponsiveViewport.matches == true)
    return(false);
    
    var objHovered = jQuery(this);    
    var objItem = objHovered.find(linkSelector);
    
    g_objMenuItems.removeClass(g_classActive);
    objItem.addClass(g_classActive); 
    
  }
  
  /**
  * use this funciton to add active class to all menu item links
  */
  function onMenuItemMouseLeave(){
    
    if(g_isResponsiveViewport.matches == true)
    return(false);
    
    var objHovered = jQuery(this);    
    var objItem = objHovered.find(linkSelector);
    
    objItem.removeClass(g_classActive);
    
  }
  
  function setFirstLevelIcons(){
    
    if(g_showIcons == false)
    return(false);          
    
    var objFirstLevelMenuLinks = g_objFirstLevelMenuItems.find(linkSelector); 
    var objFirstLevelExpandIcon = g_objMenu.find('.ue-nav-menu-icon-first-level-expand');
    var firstLevelExpandIconHtml = objFirstLevelExpandIcon.html();
    var iconWrapperHtml = "<span class='ue-nav-menu-icon'>"+firstLevelExpandIconHtml+"</span>";
    
    objFirstLevelMenuLinks.append(iconWrapperHtml);
    
  }
  
  function setIcons(){
    
    if(g_showIcons == false)
    return(false);
    
    if(!g_objMenuInnerItems)
    return(false);  
    
    var objMenuLinks = g_objMenuInnerItems.find(linkSelector);  
    var iconHtml = "<span class='ue-nav-menu-icon'>"+g_expandIconHtml+"</span>";
    
    objMenuLinks.append(iconHtml);
    
  }
  
  function onBurgerClick(){
    
    if(g_objBurger.hasClass(g_classActive) == true){
      
      g_objOpenBurgerIcon.addClass(g_classActive);
      g_objCloseBurgerIcon.removeClass(g_classActive);
      
      g_objBurger.removeClass(g_classActive);
      
    }else{
      
      g_objOpenBurgerIcon.removeClass(g_classActive);
      g_objCloseBurgerIcon.addClass(g_classActive);
      
      g_objBurger.addClass(g_classActive);
      
    }
    
  }
  
  function onKeyDown(e){
    
    //only on desktop
    if(g_isResponsiveViewport.matches == true)
    return(true);  
    
    //listen only after 'tab' key
    if(e.keyCode != 9)
    return(true);      
    
    //find all 'li' tags
    var objItems = g_objMenu.find('li');  
    
    //set small timeout, so current menu item was mark as focused and triggered
    setTimeout(function(){
      
      //look after all menu 'li' tags
      objItems.each(function(){
        
        var objItem = jQuery(this);      
        
        //if link not focused - skip
        if(objItem.find(linkSelector).is(':focus') == false)
        return(true);            
        
        var objLink = objItem.find(linkSelector);
        var objSubMenu = objLink.next();
        
        //remove active class from others menu items except parent ones    
        var objMenuLinksParent = objLink.parents(subMenuSelector).prev();
        var objMenuLinksNotParents = g_objMenu.find('.ue-menu '+menuItemSelector+' '+subMenuSelector+' a').not(objMenuLinksParent);
        var objParentsMenuitems = objItem.parents(menuItemSelector);
        var objMenuItemsNotParents = objItems.not(objParentsMenuitems);
        
        var objFirstLevelMenuLinks = jQuery('.ue-nav-menu .ue-menu > li '+linkSelector+'');
        var isFocusedFirstLevelActiveChildrenLinks = objFirstLevelMenuLinks.next().find('li '+linkSelector).is(':focus');
        
        //if there is no expanded menu items inside first level menu items then remove active class      
        if(isFocusedFirstLevelActiveChildrenLinks == false)
        objFirstLevelMenuLinks.removeClass(g_classActive);     
        
        objMenuLinksNotParents.removeClass(g_classActive);
        objMenuItemsNotParents.removeClass(g_classActive);
        
        setDisactiveIcon(objMenuLinksNotParents);
        
        //add active class and use css to open sub menu
        objItem.addClass(g_classActive);	                  
        objLink.addClass(g_classActive); 
        
        var objParentMenuItemNum = objLink.parents(menuItemSelector).length;
        
        if(objParentMenuItemNum > 1)
        setActiveIcon(objLink);
        
      });
      
    },50)  
  }
  
  /**
  * close menu on body click
  */
  function onBodyClick(e){
    
    if(g_isResponsiveViewport.matches == true)
    return(true);
    
    var objTarget = jQuery(e.target);
    var objTargetParents = objTarget.parents();
    
    if(objTargetParents.hasClass('ue-nav-menu'))
    return(true);
    
    g_objMenuItems.removeClass(g_classActive);
    g_objMenuLinks.removeClass(g_classActive);
    
    setDisactiveIcon(g_objMenuLinks); 
    
  }
  
  setFirstLevelIcons();
  setIcons();
  initResponsiveMode();
  
  //init events
  jQuery(window).on('resize', initResponsiveMode);
  
  g_objMenuLinks.on('click', onMenuLinkClick);
  
  g_objBurger.on('click', onBurgerClick);
  
  if(g_objMenuInnerItems){
    
    g_objMenuInnerItems.on('mouseover', onMenuInnerItemMouseover);
    g_objMenuInnerItems.on('mouseleave', onMenuInnerItemMouseLeave);
    
  }
  
  if(g_objMenuItems){
    
    g_objMenuItems.on('mouseover', onMenuItemMouseover);
    g_objMenuItems.on('mouseleave', onMenuItemMouseLeave);
    
  }
  
  jQuery(document).on('keydown', onKeyDown);
  
  jQuery('body').on('click', function(e){
    onBodyClick(e);
  });
  
});