<?php
/**
 * Theme functions and definitions
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'SANCHA_VERSION', '2.4.1' );
define( 'SANCHA_ASSETS_URL', get_template_directory_uri() . '/assets' );

if ( ! isset( $content_width ) ) {
	$content_width = 800; // Pixels.
}

if ( ! function_exists( 'sancha_setup' ) ) {
	/**
	 * Set up theme support.
	 *
	 * @return void
	 */
	function sancha_setup() {
	    if ( is_admin() ) {
	        sancha_update_theme_version_in_db();
	    }
	    
		if ( apply_filters( 'sancha_load_textdomain', true ) ) {
			load_theme_textdomain( 'sancha', get_template_directory() . '/languages' );
		}

		if ( apply_filters( 'sancha_register_menus', true ) ) {
			register_nav_menus( [ 'menu-1' => __( 'Header', 'sancha' ) ] );
			register_nav_menus( [ 'menu-2' => __( 'Footer', 'sancha' ) ] );
		}

		if ( apply_filters( 'sancha_add_theme_support', true ) ) {
			add_theme_support( 'post-thumbnails' );
			add_theme_support( 'automatic-feed-links' );
			add_theme_support( 'title-tag' );
			add_theme_support(
				'html5',
				[
					'search-form',
					'comment-form',
					'comment-list',
					'gallery',
					'caption',
				]
			);
			add_theme_support(
				'custom-logo',
				[
					'height'      => 100,
					'width'       => 350,
					'flex-height' => true,
					'flex-width'  => true,
				]
			);
			
			/*
			 * Editor Style.
			 */
			add_editor_style( 'classic-editor.css' );
			
			/*
			 * Gutenberg wide images.
			 */
			add_theme_support( 'align-wide' );

			/*
			 * WooCommerce.
			 */
			if ( apply_filters( 'sancha_add_woocommerce_support', true ) ) {
				// WooCommerce in general.
				add_theme_support( 'woocommerce' );
				// Enabling WooCommerce product gallery features (are off by default since WC 3.0.0).
				// zoom.
				add_theme_support( 'wc-product-gallery-zoom' );
				// lightbox.
				add_theme_support( 'wc-product-gallery-lightbox' );
				// swipe.
				add_theme_support( 'wc-product-gallery-slider' );
			}
		}
	}
}
add_action( 'after_setup_theme', 'sancha_setup' );

function sancha_update_theme_version_in_db() {
    $theme_version_option_name = 'sancha_theme_version';
    // The theme version saved in the database.
    $sancha_theme_db_version = get_option( $theme_version_option_name );
    
    // If the 'sancha_theme_version' option does not exist in the DB, or the version needs to be updated, do the update.
    if ( ! $sancha_theme_db_version || version_compare( $sancha_theme_db_version, SANCHA_VERSION, '<' ) ) {
        update_option( $theme_version_option_name, SANCHA_VERSION );
    }
}

if ( ! function_exists( 'sancha_base_scripts_styles' ) ) {
	/**
	 * Theme Scripts & Styles.
	 *
	 * @return void
	 */
    function sancha_base_scripts_styles() {
		$min_suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		if ( apply_filters( 'sancha_enqueue_style', true ) ) {
			wp_enqueue_style(
				'sancha',
				get_template_directory_uri() . '/style' . $min_suffix . '.css',
				[],
				SANCHA_VERSION
			);
		}
		
		if ( apply_filters( 'sancha_enqueue_theme_style', get_theme_mod( '_wp_element_css', false ) ) ) {
			wp_enqueue_style(
				'sancha-theme',
			    SANCHA_ASSETS_URL . '/css/theme' . $min_suffix . '.css',
				[],
				SANCHA_VERSION
			);
		}
		
	}
}
add_action( 'wp_enqueue_scripts', 'sancha_base_scripts_styles' );

if ( ! function_exists( 'sancha_scripts_styles_after_elementor' ) ) {
    /**
     * Theme Scripts & Styles.
     *
     * @return void
     */
    function sancha_scripts_styles_after_elementor() {
        $min_suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

        if ( apply_filters( 'sancha_enqueue_custom_style', true ) ) {
            wp_enqueue_style(
                'sancha-custom',
                SANCHA_ASSETS_URL . '/css/custom.css',
                [],
                SANCHA_VERSION
                );
        }
    }
}
add_action( 'elementor/frontend/after_enqueue_styles', 'sancha_scripts_styles_after_elementor', 200 );


if ( ! function_exists( 'sancha_register_elementor_locations' ) ) {
	/**
	 * Register Elementor Locations.
	 *
	 * @param ElementorPro\Modules\ThemeBuilder\Classes\Locations_Manager $elementor_theme_manager theme manager.
	 *
	 * @return void
	 */
	function sancha_register_elementor_locations( $elementor_theme_manager ) {
		if ( apply_filters( 'sancha_register_elementor_locations', true ) ) {
			$elementor_theme_manager->register_all_core_location();
		}
	}
}
add_action( 'elementor/theme/register_locations', 'sancha_register_elementor_locations' );

if ( ! function_exists( 'sancha_content_width' ) ) {
	/**
	 * Set default content width.
	 *
	 * @return void
	 */
	function sancha_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'sancha_content_width', 800 );
	}
}
add_action( 'after_setup_theme', 'sancha_content_width', 0 );

if ( is_admin() ) {
	require get_template_directory() . '/includes/admin-functions.php';
}

/**
 * Include customizer registration functions
 */
function sancha_register_customizer_functions() {
    if ( is_customize_preview() ) {
        require get_template_directory() . '/includes/customizer-functions.php';
    }
}
add_action( 'init', 'sancha_register_customizer_functions' );

if ( ! function_exists( 'sancha_check_hide_title' ) ) {
	/**
	 * Check hide title.
	 *
	 * @param bool $val default value.
	 *
	 * @return bool
	 */
	function sancha_check_hide_title( $val ) {
		if ( defined( 'ELEMENTOR_VERSION' ) ) {
			$current_doc = \Elementor\Plugin::instance()->documents->get( get_the_ID() );
			if ( $current_doc && 'yes' === $current_doc->get_settings( 'hide_title' ) ) {
				$val = false;
			}
		}
		return $val;
	}
}
add_filter( 'sancha_page_title', 'sancha_check_hide_title' );

/**
 * Wrapper function to deal with backwards compatibility.
 */
if ( ! function_exists( 'sancha_body_open' ) ) {
	function sancha_body_open() {
		if ( function_exists( 'wp_body_open' ) ) {
			wp_body_open();
		} else {
			do_action( 'wp_body_open' );
		}
	}
}

//Allow shortcodes in widgets
add_filter ( 'widget_text', 'do_shortcode' );

/**
* create copyright year shortcode to use in widgets, post and pages.
*/
add_shortcode( 'cp_year', function() {
    return date_i18n( 'Y' );
});
