<?php
/**
 * Sancha admin functions.
 *
 */

/**
 * Show in WP Dashboard notice about the plugin is not activated.
 *
 * @return void
 */
function sancha_fail_load_admin_notice() {
	// Leave to Elementor Pro to manage this.
	if ( function_exists( 'elementor_pro_load_plugin' ) ) {
		return;
	}

	$screen = get_current_screen();
	if ( isset( $screen->parent_file ) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id ) {
		return;
	}

	if ( 'true' === get_user_meta( get_current_user_id(), '_sancha_install_notice', true ) ) {
		return;
	}

	$plugin = 'elementor/elementor.php';

	$installed_plugins = get_plugins();

	$is_elementor_installed = isset( $installed_plugins[ $plugin ] );

	if ( $is_elementor_installed ) {
		if ( ! current_user_can( 'activate_plugins' ) ) {
			return;
		}

		$message = __( 'Hello theme is a lightweight starter theme designed to work perfectly with Elementor Page Builder plugin.', 'sancha' );

		$button_text = __( 'Activate Elementor', 'sancha' );
		$button_link = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin );
	} else {
		if ( ! current_user_can( 'install_plugins' ) ) {
			return;
		}

		$message = __( 'Hello theme is a lightweight starter theme. We recommend you use it together with Elementor Page Builder plugin, they work perfectly together!', 'sancha' );

		$button_text = __( 'Install Elementor', 'sancha' );
		$button_link = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=elementor' ), 'install-plugin_elementor' );
	}

	?>
	<style>
		.notice.sancha-notice {
			border-left-color: #9b0a46 !important;
			padding: 20px;
		}
		.rtl .notice.sancha-notice {
			border-right-color: #9b0a46 !important;
		}
		.notice.sancha-notice .sancha-notice-inner {
			display: table;
			width: 100%;
		}
		.notice.sancha-notice .sancha-notice-inner .sancha-notice-icon,
		.notice.sancha-notice .sancha-notice-inner .sancha-notice-content,
		.notice.sancha-notice .sancha-notice-inner .sancha-install-now {
			display: table-cell;
			vertical-align: middle;
		}
		.notice.sancha-notice .sancha-notice-icon {
			color: #9b0a46;
			font-size: 50px;
			width: 50px;
		}
		.notice.sancha-notice .sancha-notice-content {
			padding: 0 20px;
		}
		.notice.sancha-notice p {
			padding: 0;
			margin: 0;
		}
		.notice.sancha-notice h3 {
			margin: 0 0 5px;
		}
		.notice.sancha-notice .sancha-install-now {
			text-align: center;
		}
		.notice.sancha-notice .sancha-install-now .sancha-install-button {
			padding: 5px 30px;
			height: auto;
			line-height: 20px;
			text-transform: capitalize;
		}
		.notice.sancha-notice .sancha-install-now .sancha-install-button i {
			padding-right: 5px;
		}
		.rtl .notice.sancha-notice .sancha-install-now .sancha-install-button i {
			padding-right: 0;
			padding-left: 5px;
		}
		.notice.sancha-notice .sancha-install-now .sancha-install-button:active {
			transform: translateY(1px);
		}
		@media (max-width: 767px) {
			.notice.sancha-notice {
				padding: 10px;
			}
			.notice.sancha-notice .sancha-notice-inner {
				display: block;
			}
			.notice.sancha-notice .sancha-notice-inner .sancha-notice-content {
				display: block;
				padding: 0;
			}
			.notice.sancha-notice .sancha-notice-inner .sancha-notice-icon,
			.notice.sancha-notice .sancha-notice-inner .sancha-install-now {
				display: none;
			}
		}
	</style>
	<script>jQuery( function( $ ) {
			$( 'div.notice.sancha-install-elementor' ).on( 'click', 'button.notice-dismiss', function( event ) {
				event.preventDefault();

				$.post( ajaxurl, {
					action: 'sancha_set_admin_notice_viewed'
				} );
			} );
		} );</script>
	<div class="notice updated is-dismissible sancha-notice sancha-install-elementor">
		<div class="sancha-notice-inner">
			<div class="sancha-notice-icon">
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/elementor-logo.png' ); ?>" alt="Elementor Logo" />
			</div>

			<div class="sancha-notice-content">
				<h3><?php esc_html_e( 'Thanks for installing Sancha Theme!', 'sancha' ); ?></h3>
				<p>
					<p><?php echo esc_html( $message ); ?></p>
					<a href="https://go.elementor.com/hello-theme-learn/" target="_blank"><?php esc_html_e( 'Learn more about Elementor', 'sancha' ); ?></a>
				</p>
			</div>

			<div class="sancha-install-now">
				<a class="button button-primary sancha-install-button" href="<?php echo esc_attr( $button_link ); ?>"><i class="dashicons dashicons-download"></i><?php echo esc_html( $button_text ); ?></a>
			</div>
		</div>
	</div>
	<?php
}

/**
 * Set Admin Notice Viewed.
 *
 * @return void
 */
function ajax_sancha_set_admin_notice_viewed() {
	update_user_meta( get_current_user_id(), '_sancha_install_notice', 'true' );
	die;
}

add_action( 'wp_ajax_sancha_set_admin_notice_viewed', 'ajax_sancha_set_admin_notice_viewed' );

if ( ! did_action( 'elementor/loaded' ) ) {
	add_action( 'admin_notices', 'sancha_fail_load_admin_notice' );
}
