<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Register Customizer controls
 * 
 * @param WP_Customize_Manager $wp_customize
 *
 * @return void
 */
add_action( 'customize_register', 'sancha_customizer_register' );
function sancha_customizer_register( $wp_customize ) {

	$wp_customize->add_section(
		'sancha_theme_settings',
		[
		    'title' => esc_html__( 'Sancha Theme Settings', 'sancha' ),
			'capability' => 'edit_theme_options',
		    'priority' => 200,
		]
	);

	$wp_customize->add_setting(
		'_wp_element_css',
	    [
	        'default' => '',
	        'sanitize_callback' => function( $value ) {
	           return (bool) $value;
	        },
	    ]
	);
	
	$wp_customize->add_control(
	    '_wp_element_css', 
	    [
    	    'type' => 'checkbox',
	        'label' => esc_html__( 'Enable WP CSS', 'sancha' ),
	        'description' => esc_html__( 'Enque the themecss file which contains Wordpress core element CSS.', 'sancha' ),
    	    'section'     => 'sancha_theme_settings',
	   ]
	);

}
